#!/bin/sh

if [[ ! $LCG_GFAL_VO ]] ; then
    echo "Environment variable LCG_GFAL_VO not defined."
    exit 1
fi

if [[ ! $DEST ]] ; then
    echo "Environment variable DEST not defined."
    exit 1
fi
I=0
for D in `echo "$DEST" | tr -d '\n' | tr ',' ' '` ; do
    DESTVEC[$I]=$D
    I=$(($I+1))
done

if [[ `glite-voms-proxy-info -vo` != $LCG_GFAL_VO ]] ; then
    echo "Grid proxy not valid for LCG_GFAL_VO==$LCG_GFAL_VO."
    exit 1
fi

OUTFILE=$1
if [[ `gexists.sh $OUTFILE` != "File." ]] ; then
    echo "File $OUTFILE does not exist."
    exit 1
fi

J=1
while (( $J < $I )) ; do
    TRIES=0
    RESULT=1
    while (( $RESULT != 0 )) ; do
	lcg-rep --vo $LCG_GFAL_VO -d ${DESTVEC[$J]} lfn:$OUTFILE
	RESULT=$?
	TRIES=$(($TRIES+1))
	if (( $TRIES >= 5 )) ; then
	    echo "The line 'lcg-rep --vo $LCG_GFAL_VO -d ${DESTVEC[$J]} lfn:$OUTFILE' failed."
	    echo "Giving up after 5 tries."
	    exit 1
	fi
	if (( $RESULT != 0 )) ; then sleep 10s ; fi
    done
    J=$(($J+1))
done
