#!/bin/sh

if [[ ! $LCG_GFAL_VO ]] ; then
    echo "Environment variable LCG_GFAL_VO not defined."
    exit 1
fi

if [[ `glite-voms-proxy-info -vo` != $LCG_GFAL_VO ]] ; then
    echo "Grid proxy not valid for LCG_GFAL_VO==$LCG_GFAL_VO."
    exit 1
fi

INFILE=$1
if [[ `gexists.sh $INFILE` != "File." ]] ; then
    echo "File $INFILE does not exist."
    exit 1
fi

OUTFILE=$2
if [[ -d $OUTFILE ]] ; then
    OLDDIR=$PWD
    cd $OUTFILE
    OUTFILE=$PWD/`basename $1`
    cd $OLDDIR
fi

TRIES=0
RESULT=1
while (( $RESULT != 0 )) ; do
    lcg-cp --vo $LCG_GFAL_VO lfn:$INFILE file:$OUTFILE
    RESULT=$?
    TRIES=$(($TRIES+1))
    if (( $TRIES >= 5 )) ; then
	echo "The line 'lcg-cp --vo $LCG_GFAL_VO lfn:$INFILE file:$OUTFILE' failed."
	echo "Giving up after 5 tries."
	exit 1
    fi
    if (( $RESULT != 0 )) ; then sleep 10s ; fi
done
