#!/bin/sh

if [[ ! $LCG_GFAL_VO ]] ; then
    echo "Environment variable LCG_GFAL_VO not defined."
    exit 1
fi

if [[ `glite-voms-proxy-info -vo` != $LCG_GFAL_VO ]] ; then
    echo "Grid proxy not valid for LCG_GFAL_VO==$LCG_GFAL_VO."
    exit 1
fi

if [[ `gexists.sh $1` != "File." ]] ; then
    echo "File $1 does not exist."
    exit 1
fi

TRIES=0
RESULT=1
while (( $RESULT != 0 )) ; do
    lcg-del --vo $LCG_GFAL_VO -a lfn:$1
    RESULT=$?
    TRIES=$(($TRIES+1))
    if (( $TRIES >= 5 )) ; then
	echo "The line 'lcg-del --vo $LCG_GFAL_VO -a lfn:$1' failed."
	echo "Giving up after 5 tries."
	exit 1
    fi
    if (( $RESULT != 0 )) ; then sleep 10s ; fi
done
