#!/bin/sh

if [[ ! $LCG_GFAL_VO ]] ; then
    echo "Environment variable LCG_GFAL_VO not defined."
    exit 1
fi

if [[ ! $DEST ]] ; then
    echo "Environment variable DEST not defined."
    exit 1
fi

if [[ `glite-voms-proxy-info -vo` != $LCG_GFAL_VO ]] ; then
    echo "Grid proxy not valid for LCG_GFAL_VO==$LCG_GFAL_VO."
    exit 1
fi

INFILE=$1
if ! [ -f $INFILE ] ; then
    echo "Reference local file $INFILE does not exist."
    exit 1
fi

OUTFILE=$2
if [[ `gexists.sh $OUTFILE` != "File." ]] ; then
    echo "File $OUTFILE does not exist."
    exit 1
fi

SRMS=`lcg-lr --vo $LCG_GFAL_VO lfn:$OUTFILE`
if [[ "$SRMS" == "" ]] ; then
    echo "For $OUTFILE no replicas exist."
    exit 1
fi

REFCHSUM=`lcg-get-checksum file:$INFILE`
ERR=$?
REFCHSUM=`echo "$REFCHSUM" | tr -d '\n' | tr '\t' ' ' | tr -s ' ' | cut -f 1 -d ' '`
if (( $ERR !=0 )) ; then
    echo "Reference checksum retreival for $INFILE failed."
    exit 1
fi
ERRORCODE=0
for F in $SRMS ; do
    CHSUM=`lcg-get-checksum --vo $LCG_GFAL_VO $F 2>/dev/null`
    ERR=$?
    CHSUM=`echo "$CHSUM" | tr -d '\n' | tr '\t' ' ' | tr -s ' ' | cut -f 1 -d ' '`
    if (( $ERR != 0 )) ; then
	echo "Checksum retreival for $F failed."
	ERRORCODE=1
    elif [[ "$CHSUM" != "$REFCHSUM" ]] ; then
	echo "Checksum for $F is not OK ($CHSUM!=$REFCHSUM)."
	ERRORCODE=2
    else
	echo "Checksum for $F is OK ($CHSUM)."
    fi
done

if (( $ERRORCODE == 0 )) ; then echo "All checksums OK." ; 
elif (( $ERRORCODE == 1 )) ; then echo "Some checksum retreivals failed." ; 
else echo "Some checksums were not OK." ; fi

exit $ERRORCODE
