#!/bin/sh

if [[ ! $LCG_GFAL_VO ]] ; then
    echo "Environment variable LCG_GFAL_VO not defined."
    exit 1
fi

if ! ( grid-proxy-info -e >&/dev/null ) ; then
    echo "Grid proxy not valid."
    exit 1
fi

OUTFILE=$1
if [[ `gexists.sh $OUTFILE` != "Exists." ]] ; then
    echo "$OUTFILE does not exist."
    exit 1
fi

OUTHOST=$2
if [[ ! $OUTHOST ]] ; then
    echo "Output host has to be set."
    exit 1
fi

TRIES=0
RESULT=1
while (( $RESULT != 0 )) ; do
    lcg-rep --vo $LCG_GFAL_VO -d $OUTHOST lfn:$OUTFILE
    RESULT=$?
    TRIES=$(($TRIES+1))
    if (( $TRIES >= 5 )) ; then
	echo "The line 'lcg-rep --vo $LCG_GFAL_VO -d $OUTHOST lfn:$OUTFILE' failed."
	echo "Giving up after 5 tries."
	exit 1
    fi
done
