#!/bin/sh

if [[ ! $LCG_GFAL_VO ]] ; then
    echo "Environment variable LCG_GFAL_VO not defined."
    exit 1
fi

if [[ ! $DEST ]] ; then
    echo "Environment variable DEST not defined."
    exit 1
fi
I=0
for D in `echo "$DEST" | tr -d '\n' | tr ',' ' '` ; do
    DESTVEC[$I]=$D
    I=$(($I+1))
done

if ! ( grid-proxy-info -e >&/dev/null ) ; then
    echo "Grid proxy not valid."
    exit 1
fi

OUTFILE=$2
if [[ `gexists.sh $2` == "Directory." ]] ; then
    OUTFILE=$2/`basename $1`
fi

if [[ `gexists.sh $OUTFILE` == "Exists." ]] ; then
    gdel.sh $OUTFILE
fi

OLDDIR=$PWD
DIR=`dirname $1`
if [[ $DIR == "" ]] ; then DIR="." ; fi
cd $DIR
FILE=$PWD/`basename $1`
cd $OLDDIR

TRIES=0
RESULT=1
while (( $RESULT != 0 )) ; do
    lcg-cr --vo $LCG_GFAL_VO -d ${DESTVEC[0]} -l lfn:$OUTFILE file:$FILE
    RESULT=$?
    TRIES=$(($TRIES+1))
    if (( $TRIES >= 5 )) ; then
	echo "The line 'lcg-cr --vo $LCG_GFAL_VO -d ${DESTVEC[0]} -l lfn:$OUTFILE file:$FILE' failed."
	echo "Giving up after 5 tries."
	exit 1
    fi
done
