#!/bin/sh

if [[ ! $LCG_GFAL_VO ]] ; then
    echo "Environment variable LCG_GFAL_VO not defined."
    exit 1
fi

if ! ( grid-proxy-info -e >&/dev/null ) ; then
    echo "Grid proxy not valid."
    exit 1
fi

if [[ `gexists.sh $1` != "Exists." ]] ; then
    echo "$1 does not exist."
    exit 0
fi

TRIES=0
RESULT=1
while (( $RESULT != 0 )) ; do
    lcg-del --vo $LCG_GFAL_VO -a lfn:$1
    RESULT=$?
    TRIES=$(($TRIES+1))
    if (( $TRIES >= 5 )) ; then
	echo "The line 'lcg-del --vo $LCG_GFAL_VO -a lfn:$1' failed."
	echo "Giving up after 5 tries."
	exit 1
    fi
done
