#include "RecoPixelVZero/PixelVZeroFinding/interface/PixelVZeroProducer.h"
#include "RecoPixelVZero/PixelVZeroFinding/interface/PixelVZeroFinder.h"

#include "FWCore/Framework/interface/MakerMacros.h"
#include "FWCore/Framework/interface/ESHandle.h"
#include "FWCore/Framework/interface/Frameworkfwd.h"
#include "FWCore/ServiceRegistry/interface/Service.h"

#include "FWCore/ParameterSet/interface/ParameterSet.h"
#include "FWCore/MessageLogger/interface/MessageLogger.h"

/*****************************************************************************/
PixelVZeroProducer::PixelVZeroProducer(const edm::ParameterSet& pset)
  : pset_(pset)
{
  edm::LogInfo("PixelVZeroProducer") << " constructor";
  produces<reco::VZeroCollection>();
}

/*****************************************************************************/
PixelVZeroProducer::~PixelVZeroProducer()
{
  edm::LogInfo("PixelVZeroProducer") << " destructor";
}

/*****************************************************************************/
void PixelVZeroProducer::produce(edm::Event& ev, const edm::EventSetup& es)
{
  LogDebug("PixelVZeroProducer, produce")<<"event# :"<<ev.id();

  edm::Handle<reco::TrackCollection> trackCollection;
  ev.getByLabel("pxTracks",trackCollection);

  // Get tracks
  const reco::TrackCollection tracks = *(trackCollection.product());

  // Find vzeros
  PixelVZeroFinder theFinder(es,pset_, tracks);
  reco::VZeroCollection vZeros = theFinder.doIt();

  // Put into the event
  std::auto_ptr<reco::VZeroCollection> result(new reco::VZeroCollection); 
  for(reco::VZeroCollection::const_iterator it = vZeros.begin();
                                            it!= vZeros.end(); it++)
    result->push_back(*it);

  ev.put(result);
}

DEFINE_FWK_MODULE(PixelVZeroProducer);
