#ifndef _PixelVZeroFinder_h_
#define _PixelVZeroFinder_h_

#include "DataFormats/TrackReco/interface/Track.h"

#include "DataFormats/TrackReco/interface/VZero.h"
#include "DataFormats/TrackReco/interface/VZeroFwd.h"

#include "FWCore/Framework/interface/EventSetup.h"
#include "FWCore/Framework/interface/ESHandle.h"
#include "FWCore/ParameterSet/interface/ParameterSet.h"

class Helix
{
 public:
   int q;
   float cotTheta,pT, b, chi, R,X,Y,Z, psi;
};

class PixelVZeroFinder
{
 public:
   PixelVZeroFinder(const edm::EventSetup& es,
                    const edm::ParameterSet& pset,
                    reco::TrackCollection tracks);
   ~PixelVZeroFinder();
   reco::VZeroCollection doIt();

 private:
   std::vector<Helix> helices;
   reco::VZeroCollection vZeros;
   Helix getHelix(const reco::Track& t);
   
   bool getZ(Helix& h, float *z);
   void checkIntersection(Helix& h1,Helix& h2,float deltaR);
   void checkPair(Helix& h1,Helix& h2);

   float minImpactPositiveDaughter,
         minImpactNegativeDaughter,
         maxDcaR,
         maxDcaZ,
         minCreationRadius,
         maxCreationRadius,
         maxImpactMother; 

   float fieldInInvGeV;
};

#endif

