#!/bin/sh


PROGRAM=$1
PARAMS="$2"
OUTDIRS="$3"

echo "Sourcing profile ..."
. /afs/kfki.hu/linux/etc/profile.sh

echo "Extracting $PROGRAM.tar.gz ..."
tar -xzf $PROGRAM.tar.gz
rm -f $PROGRAM.tar.gz
echo "Changing directory to $PROGRAM ..."
cd $PROGRAM

PROGRAMSORIG=`cd src ; ls *.c *.cc *.cpp *.cxx *.c++ *.C *.f *.F 2>/dev/null ; cd ..`
PROGRAMS=""
for P in $PROGRAMSORIG ; do
 NFIELDS=$((`echo -n $P | tr -c -d '.' | wc -c`))
 PROGRAMS="$PROGRAMS `echo -n $P | cut --delimiter='.' --fields=1-$NFIELDS`"
done

echo "Cleaning up source ..."
make -s Clean

for P in $PROGRAMS ; do
 echo "Compliling $P ..."
 make -s bin/$P
done

echo "Removing old outputs ..."
for F in $OUTDIRS ; do
 rm -f $F/*
done

for P in $PROGRAMS ; do
 echo "Starting $P $PARAMS ..."
 ./bin/$P $PARAMS
done

echo "Changing directory to original directory ..."
cd ..
echo "Archiving output to out.tar.gz ..."
mv $PROGRAM/out .
tar -czf out.tar.gz out
rm -rf out
echo "Cleaning up ..."
rm -rf $PROGRAM
