#!/bin/sh
########################################################################
########################################################################
#                                                                      #
# This is an automatic 'Makefile'. One generally does not have to edit #
# this file. Just put the program sources (source files with the       #
# program body) into the 'src' directory, put the library sources      #
# (source files to be linked to the programs, or the compiled          #
# libraries or shared libraries themselves) into the 'lib'             #
# directory, put the header sources (source files to be included in)   #
# into the 'inc' directory. You can directly refer to include files in #
# 'inc' directory, as they are added to the include search path.       #
#                                                                      #
# By running the this 'go.sh' shell script in 'bin' directory (from    #
# anywhere), everything is done. This will compile source (by invoking #
# automatic 'Makefile' in the previous directory), remove old outputs, #
# run the program binaries, and plot the generated gnuplot scripts (if #
# any).                                                                #
#                                                                      #
# If you want to pass arguments to the program binaries, edit the      #
# 'PARAMS' variable. Then every binary will be run once and only once  #
# with these parameters. If you want to run the programs in a more     #
# sophisticated way, then create a file in directory 'bin' named       #
# 'arg.list', containing lines in the following format:                #
# binary_name_0 some_arguments_0                                       #
# binary_name_1 some_arguments_1                                       #
# ...                                                                  #
#                                                                      #
# Refer to 'Makefile' for compilation issues.                          #
#                                                                      #
########################################################################
########################################################################


####################### User definitions section: ######################


### Pass these parameters to the programs (run each program once):
PARAMS=

### Output directories to be cleaned up:
OUTDIRS="out/bplots out/plots out/data out/hist out/gnu"


#################### End of user definitions section. ##################

### Get directory, where the programs are located:
DIR=$PWD
DIROLD=$DIR
ROUTE=$0
NF=$((`echo -n $ROUTE | tr -c -d '/' | wc -c`))
if [[ $NF > 0 ]] ; then 
 ROUTE=`echo -n $ROUTE | cut --delimiter='/' --fields=1-$NF`
else
 ROUTE=""
fi
DIR=$DIR/$ROUTE/..

### Change to directory, where the programs are located:
cd $DIR

### Get binary names:
BINARIESORIG=`cd src ; ls *.c *.cc *.cpp *.cxx *.c++ *.C *.f *.F 2>/dev/null ; cd ..`
BINARIES=""
for B in $BINARIESORIG ; do
 NF=$((`echo -n $B | tr -c -d '.' | wc -c`))
 BINARIES="$BINARIES `echo -n $B | cut --delimiter='.' --fields=1-$NF`"
done

### Extract programs from file 'arg.list' in directory 'bin', if exists:
COMPBINARIES=""
NP=0
if [[ -e bin/arg.list ]] ; then
 for LINE in `cat bin/arg.list | tr ' ' '^' | tr '\t' '^'` ; do
  LINE=`echo -n "$LINE" | tr '^' ' '`
  NW=0
  for WORD in $LINE ; do
   if (( $NW == 0 )) && [[ "`echo -n $WORD | cut -c 1`" == "#" ]] ; then break ; fi
   if (( $NW == 0 )) && ! ( echo -n "$BINARIES" | grep "$WORD" >&/dev/null ) ; then
    echo "Cannot find $WORD among binary names! Nothing done. Exiting."
    exit 1
   fi
   if (( $NW == 0 )) ; then
    PROGRAM[$NP]=$WORD
    if ! ( echo -n "$COMPBINARIES" | grep "$WORD" >&/dev/null ) ; then COMPBINARIES="$COMPBINARIES $WORD" ; fi
   else
    PROGRAM[$NP]="${PROGRAM[$NP]} $WORD"
   fi
   NW=$(($NW+1))
  done
  if (( $NW == 0 )) ; then continue ; fi
  PROGRAM[$NP]="${PROGRAM[$NP]} $PARAMS"
  NP=$(($NP+1))
 done
fi

### As a fallback take all the binaries:
if (( $NP == 0 )) ; then
 for WORD in $BINARIES ; do
  PROGRAM[$NP]="$WORD $PARAMS"
  NP=$(($NP+1))
 done
 COMPBINARIES=$BINARIES
fi

### Compile and link sources to create binaries:
for B in $COMPBINARIES ; do
 echo "Compliling $B ..."
 make -s bin/$B
done

### Remove old outputs:
echo "Removing old outputs ..."
for F in $OUTDIRS ; do
 rm -rf $F/*
done

### Run programs:
N=0
while (( $N < $NP )) ; do
 echo "Starting ${PROGRAM[$N]} ..."
 nice -+19 ./bin/${PROGRAM[$N]}
 N=$(($N+1))
done

### Change to original directory:
cd $DIROLD
