#!/bin/sh


#################### User definitions section. #########################


### Local output directories of the jobs to be cleared before run:
OUTDIRS="out/bplots out/plots out/hist out/data out/gnu"

### Virtual Organization:
VO=cms

### Requirements:
REQ="other.GlueCEUniqueID==\"grid109.kfki.hu:2119/jobmanager-lcgpbs-cms\""


#################### End of user definitions section. ##################


DIR=$PWD
DIROLD=$DIR
ROUTE=$0
NF=$((`echo -n $ROUTE | tr -c -d '/' | wc -c`))
if [[ $NF > 0 ]] ; then 
 ROUTE=`echo -n "$ROUTE" | cut --delimiter='/' --fields=1-$NF`
else 
 ROUTE=""
fi
DIR=$DIR/$ROUTE/..

cd $DIR

NUM=0
for f in `ls log | grep "jobids"` ; do
 NUM=$(($NUM+1))
done
if [[ $NUM != 0 ]] ; then if [[ -e log/jobids ]] ; then mv log/jobids log/jobids.$NUM ; fi ; fi

for LIST in `cat inp/arg.list | tr ' ' '^' | tr '\t' '^'` ; do
 if [[ `echo -n "$LIST" | cut -c 1` == '#' ]] ; then continue ; fi
 LIST=`echo -n "$LIST" | tr '^' ' '`
 PROGRAM=`echo -n "$LIST" | cut --delimiter=' ' --fields=1`
 if [[ ! -e src/$PROGRAM.tar.gz ]] ; then echo "No src/$PROGRAM.tar.gz file! Nothing done. Exiting." ; exit 1 ; fi
done

OUTDIRS="\\\"$OUTDIRS\\\""
for LIST in `cat inp/arg.list | tr ' ' '^' | tr '\t' '^'` ; do
 if [[ `echo -n "$LIST" | cut -c 1` == '#' ]] ; then continue ; fi
 LIST=`echo -n "$LIST" | tr '^' ' '`
 PROGRAM=`echo -n "$LIST" | cut --delimiter=' ' --fields=1`
 echo -n "" > log/submit.jdl
 echo "Executable = \"job.sh\";" >> log/submit.jdl
 echo "Arguments = \"`echo -n $LIST | sed 's/\\"/\\\\"/g'` $OUTDIRS\";" >> log/submit.jdl
 echo "StdOutput = \"STDOUTERR\";" >> log/submit.jdl
 echo "StdError = \"STDOUTERR\";" >> log/submit.jdl
 echo "InputSandBox = {\"bin/job.sh\", \"src/$PROGRAM.tar.gz\"};" >> log/submit.jdl
 echo "OutputSandBox = {\"STDOUTERR\", \"out.tar.gz\"};" >> log/submit.jdl
 echo "Requirements = ($REQ);" >> log/submit.jdl
 edg-job-submit --vo $VO --output log/jobids log/submit.jdl
done
rm -f log/submit.jdl

cd $DIROLD
