#include "Utilities/Configuration/interface/Architecture.h"

#include "TrackerReco/TkHitTriplets/interface/CombinedHitTripletGenerator.h"
#include "TrackerReco/TkTrackingRegions/interface/TrackingRegion.h"
#include "TrackerReco/TkHitTriplets/interface/PixelLayerTriplets.h"
#include "TrackerReco/TkHitTriplets/src/HitTripletGeneratorFromPairAndLayers.h"
#include "TrackerReco/TkHitPairs/interface/HitPairGeneratorFromLayerPair.h"

#include "TrackerReco/TkHitTriplets/src/HitTripletGeneratorFromPairAndLayersWithHelix.h"

void CombinedHitTripletGenerator::
    hitTriplets( const TrackingRegion& region, OrderedHitTriplets & result ) 
{
  GeneratorContainer::const_iterator ic;
  for (ic = theGenerators.begin(); ic != theGenerators.end(); ic++) {
    (**ic).hitTriplets( region, result);
  }
  theLayerCache.clear();
}

CombinedHitTripletGenerator::CombinedHitTripletGenerator(
    const CombinedHitTripletGenerator &o)
{
  GeneratorContainer::const_iterator ic;
  for (ic = o.theGenerators.begin(); ic != o.theGenerators.end(); ic++) {

    vector<const DetLayer*> thirds = (**ic).thirdLayers();
    const HitPairGeneratorFromLayerPair& hpg = 
      dynamic_cast<const HitPairGeneratorFromLayerPair& >
          ( (**ic).pairGenerator() );
    const DetLayer * inner = hpg.innerLayer();
    const DetLayer * outer = hpg.outerLayer();

    theGenerators.push_back( 
        new HitTripletGeneratorFromPairAndLayers(
              HitPairGeneratorFromLayerPair( inner, outer, &theLayerCache),
              thirds,
            &theLayerCache) );
  }
}

CombinedHitTripletGenerator::~CombinedHitTripletGenerator()
{
  GeneratorContainer::const_iterator ig;
  for (ig = theGenerators.begin(); ig != theGenerators.end(); ig++) {
    delete (*ig);
  }
}

#include "Utilities/UI/interface/SimpleConfigurable.h"

void CombinedHitTripletGenerator::
    initGenerators(const PixelLayerTriplets & pixel)
{
  bool withHelix =
    SimpleConfigurable<bool>(false, "TkHitTriplets:withHelix").value();
  cerr << "  TkHitTriplets:withHelix = " << withHelix << endl;

  vector<PixelLayerTriplets::LayerPairAndLayers>::const_iterator it;
  vector<PixelLayerTriplets::LayerPairAndLayers> trilayers=pixel.layers();
  for (it = trilayers.begin(); it != trilayers.end(); it++) {
    const DetLayer * first = (*it).first.first;
    const DetLayer * second = (*it).first.second;
    vector<const DetLayer *> thirds = (*it).second;

    if(withHelix == false)
     theGenerators.push_back( new HitTripletGeneratorFromPairAndLayers(
         HitPairGeneratorFromLayerPair( first, second, &theLayerCache),
         thirds, 
         &theLayerCache) );
    else
     theGenerators.push_back( new HitTripletGeneratorFromPairAndLayersWithHelix(
         HitPairGeneratorFromLayerPair( first, second, &theLayerCache),
         thirds, 
         &theLayerCache) );
  } 
}
