#include "Utilities/Configuration/interface/Architecture.h"

#include "TrackerReco/ClusterShaper/interface/Transformations.h"

#include <cmath>

#define Mdim 8

#include <iostream>

extern geom_t geom;

/*****************************************************************************/
Transformations::Transformations() {}

/*****************************************************************************/
Transformations::~Transformations() {}

/*****************************************************************************/
void Transformations::transformEndpointToCluster(double endpoint[][2], double cluster[Npar+1])
{ 
 int k;

 for(k=0; k<2; k++) // center
  cluster[k] = (endpoint[0][k] + endpoint[1][k])/2;

 cluster[2] = 0.; // halflength
 for(k=0; k<2; k++)
  cluster[2] += sqr((endpoint[1][k] - endpoint[0][k])*geom.pitch[k]);
 cluster[2] = sqrt(cluster[2])/2;
    
 cluster[3] = atan2((endpoint[1][1] - endpoint[0][1])*geom.pitch[1], // angle
                    (endpoint[1][0] - endpoint[0][0])*geom.pitch[0]);
 if(cluster[3] < 0.    ) cluster[3] += 2*M_PI;
 if(cluster[3] >=2*M_PI) cluster[3] -= 2*M_PI;

// cluster[4] = 100.; // set eloss!
 cluster[4] = 2002002./1e+3 * 3; // set eloss! 3 MeV/c
}

/*****************************************************************************/
void Transformations::transformClusterToEndpoint(double cluster[Npar+1], double endpoint[][2])
{
 int i;

 for(i=0; i<2; i++)
 {
  endpoint[i][0] = cluster[0]-(1-2*i)*cluster[2]*cos(cluster[3])/geom.pitch[0];
  endpoint[i][1] = cluster[1]-(1-2*i)*cluster[2]*sin(cluster[3])/geom.pitch[1];
 }
}

/*****************************************************************************/
double Transformations::scalarProduct(int n, double a[],double b[])
{
 int k;
 double s=0.;

 for(k=0; k<n; k++) s += a[k]*b[k];

 return(s);
}

/*****************************************************************************/
void Transformations::transformClusterToTrack(double pos[], double track[])
{
 int i, dfrom,dto, q;
 double nev[Mdim], w[2], s11,s12,s22, r_T,v_T, par[Mdim];

 ///////////////////////////////////////////////////////////////
 // [local 2d] center x, center y, half-length(cm), angle [pitch]
 dfrom=4; dto=4;

 w[0] = cos(pos[3]); w[1] = sin(pos[3]);

 nev[0] = pos[0] - pos[2]/geom.pitch[0] * w[0];
 nev[1] = pos[1] - pos[2]/geom.pitch[1] * w[1];
 nev[2] = pos[0] + pos[2]/geom.pitch[0] * w[0];
 nev[3] = pos[1] + pos[2]/geom.pitch[1] * w[1];
 for(i=0; i<dto; i++) par[i] = nev[i];

 ///////////////////////////////////////////////////////////////
 // [local 2d] entry x, entry y, exit x, exit y [pitch]
 dfrom=4; dto=6;

 nev[0] = par[0] + ( geom.flipped ? -geom.shift[0] : 0); // undo Lorentz-shift
 nev[1] = par[1] + ( geom.flipped ? -geom.shift[1] : 0);
 nev[2] = -geom.thickness/2 * (geom.flipped ? -1 : 1);

 nev[3] = par[2] + (!geom.flipped ? -geom.shift[0] : 0);
 nev[4] = par[3] + (!geom.flipped ? -geom.shift[1] : 0);
 nev[5] =  geom.thickness/2 * (geom.flipped ? -1 : 1);

 nev[0] = (nev[0] - geom.center[0]) * geom.pitch[0]; // pitch -> cm
 nev[1] = (nev[1] - geom.center[1]) * geom.pitch[1];
 nev[3] = (nev[3] - geom.center[0]) * geom.pitch[0];
 nev[4] = (nev[4] - geom.center[1]) * geom.pitch[1];

 for(i=0; i<dto; i++) par[i] = nev[i];

 ///////////////////////////////////////////////////////////////
 // [local 3d] entry x, entry y, entry z, exit x, exit y, exit z [cm]
 dfrom=6; dto=6;

 nev[0] = (par[0] + par[3])/2;
 nev[1] = (par[1] + par[4])/2;
 nev[2] = (par[2] + par[5])/2;
 nev[3] =  par[3] - par[0];
 nev[4] =  par[4] - par[1];
 nev[5] =  par[5] - par[2];
 for(i=0; i<dto; i++) par[i] = nev[i];

 ///////////////////////////////////////////////////////////////
 // [local 3d] center x, center y, center z, diff x, diff y, diff z [cm]
 dfrom=6; dto=6;

 for(i=0; i<3; i++)
 {
  nev[  i] = scalarProduct(3, geom.rot[i], &par[0]) + geom.pos[i];
  nev[3+i] = scalarProduct(3, geom.rot[i], &par[3]);
 }

 for(i=0; i<dto; i++) par[i] = nev[i];

 ///////////////////////////////////////////////////////////////
 // [global 3d] r_x, r_y, r_z, v_x, v_y, v_z
 dfrom=6; dto=7;

 q   = (par[3]*par[1] - par[4]*par[0] > 0 ? 1 : -1);

 s11 = sqrt(scalarProduct(2,&par[0],&par[0]));
 s12 =      scalarProduct(2,&par[0],&par[3]) ;
 s22 = sqrt(scalarProduct(2,&par[3],&par[3]));

 for(i=0; i<6; i++) nev[i] = par[i];
 nev[6] = 2 * acos(s12/(s11*s22));

 for(i=0; i<dto; i++) par[i] = nev[i];

 ///////////////////////////////////////////////////////////////
 // [global 3d] r_x, r_y, r_z, v_x, v_y, v_z, alpha
 dfrom=7; dto=8;

 r_T = sqrt(sqr(par[0]) + sqr(par[1]));
 v_T = sqrt(sqr(par[3]) + sqr(par[4]));

 for(i=0; i<7; i++) nev[i] = par[i];
 nev[7] = r_T/(2*sin(par[6]/2));

 for(i=0; i<dto; i++) par[i] = nev[i];

 ///////////////////////////////////////////////////////////////
 // [global 3d] r_x, r_y, r_z, v_x, v_y, v_z, alpha, rho
 dfrom=8; dto=4;

 q   = (par[3]*par[1] - par[4]*par[0] > 0 ? 1 : -1);
 v_T = sqrt(sqr(par[3]) + sqr(par[4]));

 nev[0] = par[5]/v_T;

 nev[1] = atan2(par[4],par[3]) + q*par[6];
 while(nev[1] < 0     ) nev[1] += 2*M_PI;
 while(nev[1] >=2*M_PI) nev[1] -= 2*M_PI;

 nev[2] = q / par[7];

 nev[3] = par[2] - par[6]*par[7]*nev[0];

 for(i=0; i<dto; i++) track[i] = nev[i];

 ///////////////////////////////////////////////////////////////
 // [global 3d] sinheta, phi, qkappa, z0

 // dE/dx
 track[Npar-1] = pos[Npar-1];
}

/*****************************************************************************/
void Transformations::transformGlobalVectorToTrack
 (double pos[], double track[])
{
 int i, dfrom,dto, q;
 double nev[Mdim], s11,s12,s22, r_T,v_T, par[Mdim];

 ///////////////////////////////////////////////////////////////
 // [global 3d] r_x, r_y, r_z, v_x, v_y, v_z
 dfrom=6; dto=7;

 q   = (pos[3]*pos[1] - pos[4]*pos[0] > 0 ? 1 : -1);

 s11 = sqrt(scalarProduct(2,&pos[0],&pos[0]));
 s12 =      scalarProduct(2,&pos[0],&pos[3]) ;
 s22 = sqrt(scalarProduct(2,&pos[3],&pos[3]));

 for(i=0; i<6; i++) nev[i] = pos[i];
 nev[6] = 2 * acos(s12/(s11*s22));

 for(i=0; i<dto; i++) par[i] = nev[i];

 ///////////////////////////////////////////////////////////////
 // [global 3d] r_x, r_y, r_z, v_x, v_y, v_z, alpha
 dfrom=7; dto=8;

 r_T = sqrt(sqr(par[0]) + sqr(par[1]));
 v_T = sqrt(sqr(par[3]) + sqr(par[4]));

 for(i=0; i<7; i++) nev[i] = par[i];
 nev[7] = r_T/(2*sin(par[6]/2));

 for(i=0; i<dto; i++) par[i] = nev[i];

 ///////////////////////////////////////////////////////////////
 // [global 3d] r_x, r_y, r_z, v_x, v_y, v_z, alpha, rho
 dfrom=8; dto=4;

 q   = (par[3]*par[1] - par[4]*par[0] > 0 ? 1 : -1);
 v_T = sqrt(sqr(par[3]) + sqr(par[4]));

 nev[0] = par[5]/v_T;

 nev[1] = atan2(par[4],par[3]) + q*par[6];
 while(nev[1] < 0     ) nev[1] += 2*M_PI;
 while(nev[1] >=2*M_PI) nev[1] -= 2*M_PI;

 nev[2] = q / par[7];

 nev[3] = par[2] - par[6]*par[7]*nev[0];

 for(i=0; i<dto; i++) track[i] = nev[i];

 ///////////////////////////////////////////////////////////////
 // [global 3d] sinheta, phi, qkappa, z0

 // dE/dx
 track[Npar-1] = pos[Npar-1];
}

