#include "Utilities/Configuration/interface/Architecture.h"

#include "TrackerReco/ClusterShaper/interface/ClusterMorphology.h"

/*****************************************************************************/
ClusterMorphology::ClusterMorphology() {}

/*****************************************************************************/
ClusterMorphology::~ClusterMorphology() {}

/*****************************************************************************/
void ClusterMorphology::pca(int ncha,int val[][3], double *dmax)
{
 double s=0.,Ex=0.,Ey=0.,Exx=0.,Exy=0.,Eyy=0.;

 // Principal component analysis
 for(int i=0; i<ncha; i++)
 {
  s   += 1;
  Ex  += val[i][0];
  Ey  += val[i][1];
  Exx += val[i][0] * val[i][0];
  Exy += val[i][0] * val[i][1];
  Eyy += val[i][1] * val[i][1];
 }

 // Expectation values
 Ex/=s; Ey/=s; Exx/=s; Exy/=s; Eyy/=s;

 // Covariance
 double Cxx = Exx - Ex*Ex;
 double Cxy = Exy - Ex*Ey;
 double Cyy = Eyy - Ey*Ey;

 // Determinant
 double d = sqrt(sqr(Cxx - Cyy) + 4*sqr(Cxy));

 // Sub: eigenvalue
 double lambda = ((Cxx + Cyy) - d)/2;

 // Sub: length of eigenvector
 double length = sqrt(sqr(Cxx - lambda) + sqr(Cxy));

 // Sub: angles of eigenvector
 double cosphi =             Cxy / length;
 double sinphi = -(Cxx - lambda) / length;

 // Find maximal distance in sub
 *dmax = 0.;
 for(int i=0; i<ncha; i++)
 {
  d = fabs(cosphi * (val[i][0] - Ex) +
           sinphi * (val[i][1] - Ey));
  if(d > *dmax) *dmax = d;
 }
}

