#ifndef _MATRIX_H_
#define _MATRIX_H_

#include <vector>
 
template<typename T> 

class Matrix {
 public:
   Matrix(unsigned nrows, unsigned ncols);
   class BadSize { };

   // Access methods to get the (i,j) element:
   T&       operator() (unsigned i, unsigned j);
   const T& operator() (unsigned i, unsigned j) const;

   // Access methods to get the (i) vector:
   std::vector<T>&       operator() (unsigned i);
   const std::vector<T>& operator() (unsigned i) const;

   // These throw a BoundsViolation object if i or j is too big
   class BoundsViolation { };
 
   unsigned nrows() const;  // #rows in this matrix
   unsigned ncols() const;  // #columns in this matrix
 
 private:
   std::vector<std::vector<T> > data_;
};
 
template<typename T>
inline unsigned Matrix<T>::nrows() const
 { return data_.size(); }
 
template<typename T>
inline unsigned Matrix<T>::ncols() const
 { return data_[0].size(); }
 
template<typename T>
inline T& Matrix<T>::operator() (unsigned row, unsigned col)
 {
   if (row >= nrows() || col >= ncols()) throw BoundsViolation();
   return data_[row][col];
 }
 
template<typename T>
inline const T& Matrix<T>::operator() (unsigned row, unsigned col) const
 {
   if (row >= nrows() || col >= ncols()) throw BoundsViolation();
   return data_[row][col];
 }

template<typename T>
inline std::vector<T>& Matrix<T>::operator() (unsigned row)
 {
   if (row >= nrows()) throw BoundsViolation();
   return data_[row];
 }

template<typename T>
inline const std::vector<T>& Matrix<T>::operator() (unsigned row) const
 {
   if (row >= nrows()) throw BoundsViolation();
   return data_[row];
 }
 
template<typename T>
Matrix<T>::Matrix(unsigned nrows, unsigned ncols)
   : data_ (nrows)
 {
   if (nrows == 0 || ncols == 0)
     throw BadSize();
   for (unsigned i = 0; i < nrows; ++i)
     data_[i].resize(ncols);
 }

#endif
