#include "Utilities/Configuration/interface/Architecture.h"

#include "Utilities/Notification/interface/Observer.h"
#include "Tracker/CARFTracker/interface/EventAnalyser.h"

#include "TrackerReco/TkTrackSelection/interface/SimTrackEfficiencyFilter.h"
#include "TrackerReco/TkTrackSelection/interface/RecTrackEfficiencyFilter.h"
#include "TrackerReco/TkEvent/interface/TkRecEventFromCarf.h"
#include "TrackerReco/TkEvent/interface/TkSimEvent.h"

#include "CARF/Reco/interface/RecQuery.h"
#include "CARF/Reco/interface/RecCollection.h"
#include "CARF/Reco/interface/RecQuery.h"
#include "CARF/Reco/interface/ConfigAlgoFactory.h"

#include "MagneticField/BaseMagneticField/interface/MagneticField.h"

#include "CommonReco/PatternTools/interface/RecTrack.h"

#include "TrackerReco/TkRecTrackSelection/interface/SimpleRecTrackFilter.h"

#include "TrackerReco/TkHitAssociation/interface/TkHitAssociator.h"

#include "TStopwatch.h"

#include "Tracker/TkLayout/interface/FullTracker.h"
#include "Tracker/TkLayout/interface/CmsTracker.h"

#include "CommonDet/BasicDet/interface/Det.h"
#include "CommonDet/BasicDet/interface/DetUnit.h"
#include "CommonDet/BasicDet/interface/DetType.h"

#include "CommonDet/BasicDet/interface/RecHit.h"
#include "CommonDet/DetLayout/interface/DetLayer.h"

#include "Tracker/SiPixelDet/interface/PixelDet.h"
#include "Tracker/SiPixelDet/interface/PixelDetType.h"

#include "Tracker/SiStripDet/interface/SiStripDet.h"

#include "CommonDet/BasicDet/interface/SimDet.h"
#include "CommonDet/BasicDet/interface/SimHit.h"

#include <iostream>
#include <iomanip>

#include "TStopwatch.h"

///////////////////////////////////////////////////////////////////////////////
class MyEventAnalyser : public Observer< TkSimEvent*> {
public:

  MyEventAnalyser() {
    init();
  }

  ~MyEventAnalyser() { }

  virtual void upDate( TkSimEvent* ev) {if (ev!=0) analysis(ev);}
  virtual void analysis(TkSimEvent* ev);

  void processSimHit
    (const SimHit* simHit, const PixelDet* pixelDet, const StripDet* stripDet);

  void processRecHit
    (const RecHit* recHit, const PixelDet* pixelDet, const StripDet* stripDet);

  void processDetUnit(const DetUnit* detUnit);

  Module module;
  Part part;
  SimEvent::track_container simTracks;
  SimEvent::vertex_container simVertices;

private:

};

///////////////////////////////////////////////////////////////////////////////
void MyEventAnalyser::processSimHit
(const SimHit* simHit, const PixelDet* pixelDet, const StripDet* stripDet)
{
 cerr << "    track " << simHit->trackId() 
               << " " << simHit->pabs() 
               << " " << simHit->particleType() 
               << " " << simHit->processType()
               << endl;

 if(simHit->processType() == 2)
 {
  int i = simHit->packedTrackId();
  cerr << "    primary-p " << simTracks[i].momentum().px()
                    << " " << simTracks[i].momentum().py()
                    << " " << simTracks[i].momentum().pz() << endl;
/*
  cerr << "    primary " << simTracks[i].momentum().x()
                  << " " << simTracks[i].momentum().y()
                  << " " << simTracks[i].momentum().z() << endl;
*/
  int j = simTracks[i].vertIndex();
  cerr << "    primary-v " << simVertices[j].position().x()
                  <<  " "  << simVertices[j].position().y()
                  <<  " "  << simVertices[j].position().z() << endl;
 }

 GlobalPoint g1,g2;

 if(module == pixel)
 {
  pair<float,float> p;

  p = pixelDet->specificTopology().pixel(simHit->entryPoint());
  cerr << "    entry " << p.first << " " << p.second << endl;

  p = pixelDet->specificTopology().pixel(simHit->exitPoint());
  cerr << "    exit  " << p.first << " " << p.second << endl;

  g1 = pixelDet->toGlobal(simHit->entryPoint());
  g2 = pixelDet->toGlobal(simHit->exitPoint());
 }
 else
 {
  cerr << "    entry "
       << stripDet->specificTopology().strip(simHit->entryPoint()) << endl;

  cerr << "    exit  "
       << stripDet->specificTopology().strip(simHit->exitPoint()) << endl;

  g1 = stripDet->toGlobal(simHit->entryPoint());
  g2 = stripDet->toGlobal(simHit->exitPoint());
 }

 cerr << "    local " << simHit->entryPoint()
              << " " << simHit->exitPoint() << endl;

 cerr << "    direction " 
         << simHit->localDirection().x()
  << " " << simHit->localDirection().y() 
  << " " << simHit->localDirection().z() << endl;

 cerr << "    simglobalpos "
         << simHit->globalPosition().x()
  << " " << simHit->globalPosition().y()
  << " " << simHit->globalPosition().z() << endl;

 cerr << "    simglobaldir " 
         << simHit->globalDirection().x()
  << " " << simHit->globalDirection().y() 
  << " " << simHit->globalDirection().z() << endl;
}

///////////////////////////////////////////////////////////////////////////////
void MyEventAnalyser::processRecHit
(const RecHit* recHit, const PixelDet* pixelDet, const StripDet* stripDet)
{
 // Associated simhits
 static TkHitAssociator theHitAssociator;
 vector<const SimHit*> assoc = theHitAssociator(*recHit);
 cerr << "   simhits = " << assoc.size() << endl;

 for(vector<const SimHit*>::const_iterator simHit =assoc.begin();
                                           simHit!=assoc.end(); simHit++)
  processSimHit(*simHit, pixelDet,stripDet);
   
 // Rechit position, direction
 if(module == pixel)
 {  
  pair<float,float> p =
   pixelDet->specificTopology().pixel(recHit->localPosition());
  cerr << "   position = " << p.first << " " << p.second << endl;
 }
 else
 {
  cerr << "   position = " 
       << stripDet->specificTopology().strip(recHit->localPosition()) << endl;
 }

 cerr << "   direction = " << recHit->hasDirection() << endl;

 // Rechit channels
 RecHit::ChannelContainer channels=recHit->channels();

 cerr << "   channels = " << channels.size() << endl;
 for(RecHit::ChannelIterator channel =channels.begin();
                             channel!=channels.end(); channel++)
   if(module == pixel)
   {
    int adc = pixelDet->readout().channelAdc(*channel);

    pair<int,int> pos = PixelDigi::channelToPixel(*channel);
    cerr << "    " << pos.first << " " << pos.second << " " << adc << endl;
   }
   else
   {
    int adc = stripDet->readout().channelAdc(*channel);

    cerr << "    " << *channel << " " << adc << endl;
   }

 cerr << endl;
}

///////////////////////////////////////////////////////////////////////////////
void MyEventAnalyser::processDetUnit
(const DetUnit* detUnit)
{
 cerr << " " << module
      << " " << part << endl;

 const PixelDet* pixelDet = 0;
 const StripDet* stripDet = 0;

 if(module == pixel)
  pixelDet = dynamic_cast<const PixelDet*>(detUnit);
 else
  stripDet = dynamic_cast<const StripDet*>(detUnit);

 double thickZ = detUnit->surface().bounds().thickness();
 cerr << "  thickness = " << thickZ << endl;

 // Drift direction
 LocalVector dir = detUnit->driftDirection(Local3DPoint(0.,0.,0.));
 double shiftX = dir.x()/dir.z() * thickZ;
 double shiftY = dir.y()/dir.z() * thickZ;

 cerr << "  shift = " << shiftX 
               << " " << shiftY 
               << " " << (dir.z() > 0 ? 1 : -1) << endl;

 // Flipped
 bool isflipped;

 float tmp1 = detUnit->toGlobal( Local3DPoint(0.,0.,0.) ).perp();
 float tmp2 = detUnit->toGlobal( Local3DPoint(0.,0.,1.) ).perp();
 if ( tmp2<tmp1 ) isflipped = true; else isflipped = false;
 cerr << "  flipped = " << isflipped << endl;

 // Global
 cerr << "  global = " << detUnit->toGlobal( Local3DPoint(0.,0.,0.) ).x()
                << " " << detUnit->toGlobal( Local3DPoint(0.,0.,0.) ).y()
                << " " << detUnit->toGlobal( Local3DPoint(0.,0.,0.) ).z()
      << endl;

 fprintf(stderr,"  rot %f %f %f\n",
      detUnit->toGlobal( LocalVector(1.,0.,0.) ).x(),
      detUnit->toGlobal( LocalVector(1.,0.,0.) ).y(),
      detUnit->toGlobal( LocalVector(1.,0.,0.) ).z());
 fprintf(stderr,"  rot %f %f %f\n",
      detUnit->toGlobal( LocalVector(0.,1.,0.) ).x(),
      detUnit->toGlobal( LocalVector(0.,1.,0.) ).y(),
      detUnit->toGlobal( LocalVector(0.,1.,0.) ).z());
 fprintf(stderr,"  rot %f %f %f\n",
      detUnit->toGlobal( LocalVector(0.,0.,1.) ).x(),
      detUnit->toGlobal( LocalVector(0.,0.,1.) ).y(),
      detUnit->toGlobal( LocalVector(0.,0.,1.) ).z());

 // Rechits
 // DetUnit::RecHitContainer
 vector<RecHit> recHits= detUnit->recHits();
 cerr << "  rechits = " << detUnit->recHits().size() << endl;

 // Dimension, pitch
 if(module == pixel)
 {
  cerr << "  center  ="
  << " " << pixelDet->specificTopology().pixel(Local3DPoint(0,0,0)).first
  << " " << pixelDet->specificTopology().pixel(Local3DPoint(0,0,0)).second
  << endl;

  cerr << "  dimension = " << pixelDet->specificTopology().nrows()
                << " "  << pixelDet->specificTopology().ncolumns() << endl;
  cerr << "  pitch  = " << pixelDet->specificTopology().pitch().first
                << " "  << pixelDet->specificTopology().pitch().second << endl;
 }
 else
 {
  cerr << "  center  ="
  << " " << stripDet->specificTopology().strip(Local3DPoint(0,0,0))
  << endl;
  cerr << "  dimens = " << stripDet->specificTopology().nstrips()     << endl;
  cerr << "  pitch  = " << stripDet->specificTopology().pitch()       << endl;
  cerr << "  length = " << stripDet->specificTopology().stripLength() << endl;

  for(int i=0; i<2; i++)
  for(int j=0; j<2; j++)
  {
   double x = (i-0.5) * stripDet->specificTopology().nstrips() *
                        stripDet->specificTopology().pitch();
   double y = (j-0.5) * stripDet->specificTopology().stripLength();

   GlobalPoint g = stripDet->toGlobal(Local3DPoint(x,y,0));

   cerr << "  outline = " << g.x() << " " << g.y() << " " << g.z() << endl;
  }
 }

 for(vector<RecHit>::const_iterator recHit =recHits.begin();
                                    recHit!=recHits.end(); recHit++)
  if(recHit->isValid())
   processRecHit(&(*recHit), pixelDet,stripDet);
}

///////////////////////////////////////////////////////////////////////////////
void MyEventAnalyser::analysis(TkSimEvent* simEvent)
{
  const G3EventProxy* ev = simEvent->G3eventProxy();

  int thisEvent = ev->simSignal()->id().eventInRun();
  int thisRun   = ev->simSignal()->id().runNumber();

  simTracks   = ev->simSignal()->proxy()->tracks();
  simVertices = ev->simSignal()->proxy()->vertices();

  cerr << "#################################################" << endl;
  cerr << "Run " << thisRun << "  Event " << thisEvent << endl;

  const CmsTracker::LayerContainer& al = FullTracker::instance()->allLayers();
  CmsTracker::LayerIterator ilayer; 

  TStopwatch timer;
  timer.Start();

  for(ilayer = al.begin(); ilayer != al.end(); ilayer++)
  if(ilayer->module() == pixel)
  {
    cout << " " << ilayer->module()
         << " " << ilayer->part() << endl;

    Det::DetUnitContainer theDetUnits = ilayer->detUnits();

    module = ilayer->module();
    part   = ilayer->part();

    // Detunits
    for(Det::DetUnitContainer::iterator detUnit  = theDetUnits.begin();
                                        detUnit != theDetUnits.end(); detUnit++)
     processDetUnit(*detUnit);
  }

  timer.Stop();
  cerr << "  [ClusterShaper] Done in " << timer.CpuTime() << " seconds" << endl;
}

///////////////////////////////////////////////////////////////////////////////
#include "Utilities/Notification/interface/PackageInitializer.h"

PKBuilder<MyEventAnalyser> eventAnalyser("MyEventAnalyser");
