#include "Utilities/Configuration/interface/Architecture.h"

#include "TrackerReco/ClusterShaper/interface/ProcessSimHit.h"

#include "TrackerReco/ClusterShaper/interface/Transformations.h"

#include "TrackerReco/TkHitAssociation/interface/TkHitAssociator.h"

/*
#define Nproc 17
static char *process[Nproc] = 
 {"Undefined", "Unknown", "Primary", "Hadronic", "Decay",
  "Compton", "Annihilation", "EIoni", "HIoni", "MuIoni",
  "Photon", "MuPairProd", "Conversions", "EBrem", "SynchrotronRadiation",
  "MuBrem", "MuNucl"};
*/
#define Nproc 17
static char *process[Nproc] = 
 {"Undefd", "Unknwn", "Primry", "Hadrnc", "Decay ",
  "Comptn", "Annihi", "EIoni ", "HIoni ", "MuIoni",
  "Photon", "MuPair", "Conver", "EBrem ", "SynchR",
  "MuBrem", "MuNucl"};

extern geom_t geom;

/*****************************************************************************/
ProcessSimHit::ProcessSimHit() {}

/*****************************************************************************/
ProcessSimHit::~ProcessSimHit() {}

/******************************************************************************/
void ProcessSimHit::particleName(int pdg, char *name)
{
 sprintf(name,"other");

 if(pdg ==  211) sprintf(name,"pion+");
 if(pdg == -211) sprintf(name,"pion-");

 if(pdg ==  321) sprintf(name,"kaon+");
 if(pdg == -321) sprintf(name,"kaon-");

 if(pdg == 2212) sprintf(name,"prot+");
 if(pdg ==-2212) sprintf(name,"prot-");

 if(pdg ==   11) sprintf(name,"elec+");
 if(pdg ==  -11) sprintf(name,"elec-");

 if(pdg ==   13) sprintf(name,"muon+");
 if(pdg ==  -13) sprintf(name,"muon-");
}

/******************************************************************************/
void ProcessSimHit::associate
  (const RecHit *recHit,
   const PixelDet *pixelDet, const StripDet *stripDet, double track[])
{
 // Associate simhits
 static TkHitAssociator theTkHitAssociator;
 vector<const SimHit*> assoc = theTkHitAssociator(*recHit);

 if(debug())
  cerr << "  [ClusterShaper]  simhits = " << assoc.size()
       << " | shift = " << geom.shift[0] 
                 << " " << geom.shift[1]
       << endl;

 double pmax = 0.;

 for(vector<const SimHit*>::const_iterator simHit =assoc.begin();
                                           simHit!=assoc.end(); simHit++)
 {
  if(debug())
  {
   char partname[256];
   particleName((*simHit)->particleType(), partname);

   if(pixelDet != 0)
    fprintf(stderr,
           "  [ClusterShaper]   (%.1f,%.1f - %.1f,%.1f) %s %s | p=%5.3f %.1e\n",
           pixelDet->specificTopology().pixel((*simHit)->entryPoint()).first,
           pixelDet->specificTopology().pixel((*simHit)->entryPoint()).second,
           pixelDet->specificTopology().pixel((*simHit)->exitPoint()).first,
           pixelDet->specificTopology().pixel((*simHit)->exitPoint()).second,
           process[(*simHit)->processType()], partname,
           (*simHit)->pabs(),
           (*simHit)->pabs() *
//            (*simHit)->globalDirection().perp(),
           (*simHit)->energyLoss());

   if(stripDet != 0)
    fprintf(stderr,
	   "  [ClusterShaper]   (%.1f - %.1f) %s %s | p=%5.3f %.1e\n",
	   stripDet->specificTopology().strip((*simHit)->entryPoint()),
	   stripDet->specificTopology().strip((*simHit)->exitPoint()),
	   process[(*simHit)->processType()], partname,
	   (*simHit)->pabs(),
	   (*simHit)->pabs() *
//	    (*simHit)->globalDirection().perp(),
	   (*simHit)->energyLoss());
  }

  double pos[6];
  pos[0] = (*simHit)->globalPosition().x();
  pos[1] = (*simHit)->globalPosition().y();
  pos[2] = (*simHit)->globalPosition().z();
 
  pos[3] = (*simHit)->globalDirection().x();
  pos[4] = (*simHit)->globalDirection().y();
  pos[5] = (*simHit)->globalDirection().z();
 
  // Process hit if primary
  if((*simHit)->pabs() > pmax)
  {
   pmax = (*simHit)->pabs();
   track[Npar] = (*simHit)->processType();

   Transformations theTransformations;
   theTransformations.transformGlobalVectorToTrack(pos, track);
  }
 }
}
