#include "Utilities/Configuration/interface/Architecture.h"

#include "TrackerReco/ClusterShaper/interface/ChannelsOutlier.h"

#include <cmath>

extern geom_t geom;

#include <iostream>

/*****************************************************************************/
ChannelsOutlier::ChannelsOutlier() {}

/*****************************************************************************/
ChannelsOutlier::~ChannelsOutlier() {}

/*****************************************************************************/
void ChannelsOutlier::selectEndpoints(int line[2], int point[2], int index[2])
{
 if( (line[0] <= 1 && line[1] <= 1) ||
     (line[0] >= 2 && line[1] >= 2) )
 { // crosses pixel outside (vvhh, hhvv)
  if( (point[0] <= 1 && point[1] >= 3) ||
      (point[0] == 2 && point[1] == 2) )
  { index[0] = -1; index[1] = -2; }
  else
  {
   if(point[0] <= 1) { index[0] = -2; index[1] = 1; }
                else { index[0] = -1; index[1] = 0; }
  }
 }
 else
 { // crosses pixel inside (vhvh, hvhv, vhhv, hvvh)
  if(point[0] <= 1) { index[0] = -1; index[1] = 1; } // take higher point
               else { index[0] = -2; index[1] = 0; } // take lower point
 }
}

/*****************************************************************************/
void ChannelsOutlier::invertCross2(cross_t *a, cross_t *b)
{
 cross_t c;

 for(int k=0; k<2; k++)
 {
  c.pos[k] = a->pos[k]; a->pos[k] = b->pos[k]; b->pos[k] = c.pos[k];
 }
 
 c.typ = a->typ; a->typ = b->typ; b->typ = c.typ;
 c.rel = a->rel; a->rel = b->rel; b->rel = c.rel;
}
 
/*****************************************************************************/
void ChannelsOutlier::sortVectors2(int n,cross_t cross[],int dir)
{
 int change;

 do
 {
  change=0;

  for(int i=0; i<n-1; i++)
  {
   // Reverse order
   if(cross[i].pos[dir] > cross[i+1].pos[dir])
   {
    invertCross2(&cross[i],&cross[i+1]);
    change++;
   }
  }
 }
 while(change);
}

/*****************************************************************************/
void ChannelsOutlier::fillLinesPoints(int n,cross_t cross[],
 int  line[2], int  point[2],
 int iline[4], int ipoint[2])
{
 int il=0,ik=0, k=0,l=0;

 for(int j=0; j<n; j++)
 {
  if(cross[j].typ == -1) line[il++] = k;
  if(cross[j].typ  <  0)
  {
   iline[k++] = j;
  }
  else
  {
   ipoint[l++] = j;
   point[ik++] = k;
  }
 }
}

/*****************************************************************************/
double ChannelsOutlier::calculateLength2(double a, double b, double length)
{ 
 return( fabs((b-a) * length) );
}

/*****************************************************************************/
void ChannelsOutlier::fillNormalAndRelativePosition
 (pixel_t *pixel, double center[2], cross_t *cross)
{
// push_back!!
 // Normal vector, should point outward of the pixel
 for(int k=0; k<2; k++)
  pixel->normal[pixel->nc][k] = 0.;

 if(cross->typ == -1)	// vertical
  pixel->normal[pixel->nc][0] = (cross->rel == 0 ? -1. : 1.);
 else			// horizontal
  pixel->normal[pixel->nc][1] = (cross->rel == 0 ? -1. : 1.);

 // Relative position
 for(int k=0; k<2; k++)
  pixel->dx[pixel->nc][k] = (cross->pos[k] - center[k]) * geom.pitch[k];

 (pixel->nc)++;
}

/*****************************************************************************/
void ChannelsOutlier::calculateTotalLength2(double point[][2], double *length2d, double *length3d)
{
 int k;
 double dpos[2];
 
 *length2d = 0.; // Total 2d length!!
 *length3d = 0.; // Total 3d length!!
 
 for(k=0; k<2; k++)
 {
  dpos[k] = (point[1][k] - point[0][k]);
  *length2d += sqr(dpos[k] * geom.pitch[k]);
  
  dpos[k] = (point[1][k] - point[0][k]) +
            (!geom.flipped ? 1 : -1) * (-geom.shift[k]); // undo Lorentz
  *length3d += sqr(dpos[k] * geom.pitch[k]);
 }
 
 *length3d += sqr(geom.thickness); // thickness
 
 *length2d = sqrt(*length2d);
 *length3d = sqrt(*length3d);
}

/*****************************************************************************/
void ChannelsOutlier::negativeDistance(pixel_t *pixel, double endpoint[2][2]) 
{
 int j,k, dir, n=0, line[2],point[2], iline[4],ipoint[2], index[2],i[2];
 double dpos[2], center[2], length2d,length3d;
 cross_t cross[6];

 pixel->nc = 0;
 pixel->endpoint = 0;

 pixel->sign = -1;

 // Calculate center
 for(k=0; k<2; k++)
  center[k] = (endpoint[0][k] + endpoint[1][k])/2;

 // Give endpoints
 for(j=0; j<2; j++)
 {
  for(k=0; k<2; k++)
   cross[n].pos[k] = endpoint[j][k];
  cross[n].typ = j;
  n++;
 }

 // Delta position
 for(k=0; k<2; k++)
  dpos[k] = endpoint[1][k] - endpoint[0][k];
 
 // Vertical and horizontal lines
 for(k=0; k<2; k++) // -(k+1)==-1 vertical, -(k+1)==-2 horizontal
 for(j=0; j<2; j++)
 {
  cross[n].rel    = j;
  cross[n].pos[k] = pixel->position[k]+j;

  cross[n].pos[1-k] = endpoint[0][1-k] + 
   dpos[1-k]*(cross[n].pos[k] - endpoint[0][k])/dpos[k];
  cross[n].typ = -(k+1);

  n++;
 }

 // Choose direction
 if(fabs(dpos[0]) > fabs(dpos[1])) dir=0; else dir=1;

 // Sort vectors
 sortVectors2(n,cross,dir);
 
 // Fill lines and points
 fillLinesPoints(n,cross, line,point, iline,ipoint);

 // Select endpoints
 selectEndpoints(line,point,index); 

 // Take
 for(j=0; j<2; j++)
  if(index[j] < 0)
  {
   i[j] = iline[-index[j]];

   fillNormalAndRelativePosition(pixel, center, &cross[i[j]]);
  }
  else
  {
   i[j] = ipoint[index[j]];
   (pixel->endpoint)++;
  }

 // Calculate length
 calculateTotalLength2(endpoint, &length2d, &length3d);
 pixel->length = calculateLength2(cross[i[0]].pos[dir],cross[i[1]].pos[dir],
                                 length3d/dpos[dir]);
}

