#ifndef _FIT_PROCESS_TRACKER_H_
#define _FIT_PROCESS_TRACKER_H_

#include "Header.h"

#include "Utilities/Notification/interface/Observer.h"
#include "Tracker/CARFTracker/interface/EventAnalyser.h"

#include "TrackerReco/TkEvent/interface/TkRecEventFromCarf.h"
#include "TrackerReco/TkEvent/interface/TkSimEvent.h"

#include "Tracker/TkLayout/interface/FullTracker.h"
#include "Tracker/TkLayout/interface/CmsTracker.h"

#include "CommonDet/BasicDet/interface/Det.h"
#include "CommonDet/BasicDet/interface/DetUnit.h"
#include "CommonDet/BasicDet/interface/DetType.h"
#include "CommonDet/BasicDet/interface/RecHit.h"
#include "CommonDet/DetLayout/interface/DetLayer.h"

#include "Tracker/SiPixelDet/interface/PixelDet.h"
#include "Tracker/SiPixelDet/interface/PixelDetType.h"

#include "Tracker/SiStripDet/interface/SiStripDet.h"

#include <vector>

#include "TROOT.h"
#include "TFile.h"
#include "TNtuple.h"

class ClusterMorphology;
class FitStripCluster;
class FitClusterPosition;
class FitClusterParameters;
class ProcessSimHit;

class Transformations;

class ProcessTracker
{
 public:  
   ProcessTracker(void);
   ~ProcessTracker(void);
   void doAll();

 private:
   void plotCluster(int ncha, int val[][3]);
   int getLayer(float z, float r);
   void showResult
	   (const RecHit *recHit, int ncha, int minsize, int indep, double dmax,
	    double rectrack[][Npar+1], double simtrack[Npar+1],int size[2]);
   void processStripRecHit(const RecHit *recHit, const StripDet* stripDet);
   void processPixelRecHit(const RecHit *recHit, const PixelDet* pixelDet);
   void processDetUnit
	   (const DetUnit* detUnit, Module module, Part part, geom_t *geom);

   /*
   TNtuple *z0dist;
   TFile *outfile;
   */

   vector<zvertex_t> zvertex;
   int nzvertex;
};

#endif
