#ifndef _FIT_CLUSTER_PARAMETERS_H_
#define _FIT_CLUSTER_PARAMETERS_H_

#include "Header.h"

#include <vector>

#include "TrackerReco/ClusterShaper/interface/Matrix.h"

class ChannelsTouched;
class ChannelsOutlier;
class Transformations;

class FitClusterParameters
{
 public:  
   FitClusterParameters();
   ~FitClusterParameters();
   void getFunction    (double cluster[], double *chi2);
   void getDerivatives (double cluster[], double beta[],Matrix<double>* alpha);
   void fit
     (int ncha,int val[][3], double endpoint[][2], double track[][Npar+1]);

 private:
   double function(double z, int rank);
   void fillAdc(int nchannel,channel_t *channel,
                int *npixel, vector<pixel_t>* pixel,
                double endpoint[2][2]);
   void preparePixels(double endpoint[][2]);
   double crossProduct(double a[], double b[]);
   double scalarProduct2(int n, double a[],double b[]);
   void collectDerivativesCluster
     (double par[],pixel_t *pixel, double length2d, double length3d,
      double der[], double *val);
   void calculateTotalLength3(double point[][2], double *length2d, double *length3d);

   // Measured
   int nchannel;
   vector<channel_t> channel;
 
   // Calculated
   int npixel;
   vector<pixel_t> pixel;
};

#endif
