#ifndef _ESTIMATE_PRIMARY_VERTEX_H_
#define _ESTIMATE_PRIMARY_VERTEX_H_

#include "Header.h"

#include <vector>

#include "TrackerReco/ClusterShaper/interface/Matrix.h"

#include "TrackerReco/ClusterShaper/interface/LevenbergMarquardt.h"

typedef struct {
 double z,z0;
} zclus_t;

class EstimatePrimaryVertex
{
 public:  
   EstimatePrimaryVertex();
   ~EstimatePrimaryVertex();
   void getFunction    (double par[], double *chi2);
   void getDerivatives (double par[], double beta[],Matrix<double>* alpha);
   void fit(int ndata, vector<zvertex_t> data);

 private:
   double prob(double a,double z, double z0);
   double function(double par[],double z, double z0, int rank);
   void collectDerivatives
     (double par[], zclus_t *zclus, double sec[], double der[], double *val);

   int npar;

   int nclus;
   vector<zclus_t> zclus;
};

#endif
